/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.security;

import com.ibm.hsc.cim.provider.rs6k.HscProviderUtils;
import com.ibm.hsc.security.HscPrincipal;
import java.io.IOException;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.snia.wbemcfg.GlobalConfig;

public class HscLoginModule
implements LoginModule {
    private Subject hscSubject;
    private String username;
    private CallbackHandler cbHandler;
    private final int HLModuleId = 11;
    private String roleList = null;
    private boolean loginOK = false;
    private boolean commitOK = false;

    public HscLoginModule() {
        System.loadLibrary("hsclogin");
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map map, Map map2) {
        this.hscSubject = subject;
        this.cbHandler = callbackHandler;
        if (GlobalConfig.traceLevel((int)11) >= 3) {
            System.out.println("\n (1) - HscLoginModule initialize() -\n   SUBJECT=" + subject + "\n");
        }
        HscProviderUtils.HSC_ACCESS_CONTROL = true;
    }

    public boolean login() throws LoginException {
        char[] cArray;
        if (GlobalConfig.traceLevel((int)11) >= 3) {
            System.out.println("\n (2) - HscLoginModule login() -\n");
        }
        if (this.cbHandler == null) {
            throw new LoginException("Error: Null CallbackHandler!");
        }
        Callback[] callbackArray = new Callback[]{new NameCallback("login: "), new PasswordCallback("password: ", false)};
        try {
            this.cbHandler.handle(callbackArray);
            this.username = ((NameCallback)callbackArray[0]).getName();
            char[] cArray2 = ((PasswordCallback)callbackArray[1]).getPassword();
            if (cArray2 == null) {
                cArray2 = new char[]{};
            }
            cArray = new char[cArray2.length];
            System.arraycopy(cArray2, 0, cArray, 0, cArray2.length);
            ((PasswordCallback)callbackArray[1]).clearPassword();
        }
        catch (IOException iOException) {
            throw new LoginException(iOException.toString());
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new LoginException("Error: " + unsupportedCallbackException.getCallback().toString());
        }
        if (GlobalConfig.traceLevel((int)11) >= 3) {
            System.out.println("HscLogin: Authenticating user " + this.username);
        }
        if (this.authenticate(this.username, new String(cArray)) == 0) {
            if (GlobalConfig.traceLevel((int)11) >= 3) {
                System.out.println("HscLogin: Authentication succeeded\n");
            }
            this.loginOK = true;
            return true;
        }
        if (GlobalConfig.traceLevel((int)11) >= 3) {
            System.out.println("HscLogin: Authentication failed");
        }
        this.loginOK = false;
        String string = "User (" + this.username + ") Authentication failed!";
        throw new FailedLoginException(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit() throws LoginException {
        if (GlobalConfig.traceLevel((int)11) >= 3) {
            System.out.println("\n (3) - HscLoginModule commit() -\n");
        }
        if (!this.loginOK) {
            return false;
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            this.roleList = this.getPrincipals(this.username);
        }
        this.addPrincipals();
        if (GlobalConfig.traceLevel((int)11) >= 3) {
            System.out.println("HscCommit: Committed login for user " + this.username);
        }
        this.commitOK = true;
        return true;
    }

    public boolean abort() throws LoginException {
        if (!this.loginOK) {
            if (GlobalConfig.traceLevel((int)11) >= 3) {
                System.out.println("HscAbort: Aborted login after authentication failure.");
            }
            return false;
        }
        if (this.loginOK && !this.commitOK) {
            if (GlobalConfig.traceLevel((int)11) >= 3) {
                System.out.println("HscAbort: Aborted login for user " + this.username);
            }
            this.loginOK = false;
            this.username = null;
            this.roleList = null;
        } else {
            this.logout();
        }
        return true;
    }

    public boolean logout() throws LoginException {
        this.removePrincipals();
        this.loginOK = false;
        this.commitOK = false;
        this.username = null;
        this.roleList = null;
        return true;
    }

    private int addPrincipals() {
        int n = 0;
        if (this.roleList == null) {
            return n;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.roleList, ":");
        n = stringTokenizer.countTokens();
        Set<Principal> set = this.hscSubject.getPrincipals();
        int n2 = 0;
        while (n2 < n) {
            String string = new String(stringTokenizer.nextToken());
            HscPrincipal hscPrincipal = new HscPrincipal(string);
            if (!set.contains(hscPrincipal)) {
                set.add(hscPrincipal);
            }
            ++n2;
        }
        return n;
    }

    private int removePrincipals() {
        int n = 0;
        if (this.roleList == null) {
            return n;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.roleList, ":");
        n = stringTokenizer.countTokens();
        Set<Principal> set = this.hscSubject.getPrincipals();
        int n2 = 0;
        while (n2 < n) {
            HscPrincipal hscPrincipal = new HscPrincipal(stringTokenizer.nextToken());
            set.remove(hscPrincipal);
            ++n2;
        }
        return n;
    }

    private native int authenticate(String var1, String var2);

    private native String getPrincipals(String var1);
}

